<?php
namespace TYPO3\CMS\Extbase\Tests\Unit\Property\TypeConverter;

/*                                                                        *
 * This script belongs to the Extbase framework.                            *
 *                                                                        *
 * It is free software; you can redistribute it and/or modify it under    *
 * the terms of the GNU Lesser General Public License as published by the *
 * Free Software Foundation, either version 3 of the License, or (at your *
 * option) any later version.                                             *
 *                                                                        *
 * This script is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHAN-    *
 * TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser       *
 * General Public License for more details.                               *
 *                                                                        *
 * You should have received a copy of the GNU Lesser General Public       *
 * License along with the script.                                         *
 * If not, see http://www.gnu.org/licenses/lgpl.html                      *
 *                                                                        *
 * The TYPO3 project - inspiring people to share!                         *
 *                                                                        */
/**
 * Testcase for the Float converter
 *
 * @covers \TYPO3\CMS\Extbase\Property\TypeConverter\FloatConverter<extended>
 */
class FloatConverterTest extends \TYPO3\CMS\Extbase\Tests\Unit\BaseTestCase {

	/**
	 * @var \TYPO3\CMS\Extbase\Property\TypeConverterInterface
	 */
	protected $converter;

	public function setUp() {
		$this->converter = new \TYPO3\CMS\Extbase\Property\TypeConverter\FloatConverter();
	}

	/**
	 * @test
	 */
	public function checkMetadata() {
		$this->assertEquals(array('float', 'integer', 'string'), $this->converter->getSupportedSourceTypes(), 'Source types do not match');
		$this->assertEquals('float', $this->converter->getSupportedTargetType(), 'Target type does not match');
		$this->assertEquals(1, $this->converter->getPriority(), 'Priority does not match');
	}

	/**
	 * @test
	 */
	public function convertFromShouldCastTheStringToFloat() {
		$this->assertSame(1.5, $this->converter->convertFrom('1.5', 'float'));
	}

	/**
	 * @test
	 */
	public function convertFromReturnsNullIfEmptyStringSpecified() {
		$this->assertNull($this->converter->convertFrom('', 'float'));
	}

	/**
	 * @test
	 */
	public function convertFromShouldAcceptIntegers() {
		$this->assertSame((float)123, $this->converter->convertFrom(123, 'float'));
	}

	/**
	 * @test
	 */
	public function convertFromReturnsAnErrorIfSpecifiedStringIsNotNumeric() {
		$this->assertInstanceOf('TYPO3\CMS\Extbase\Error\Error', $this->converter->convertFrom('not numeric', 'float'));
	}

	/**
	 * @test
	 */
	public function canConvertFromShouldReturnTrue() {
		$this->assertTrue($this->converter->canConvertFrom('1.5', 'float'));
	}

	/**
	 * @test
	 */
	public function canConvertFromShouldReturnTrueForAnEmptyValue() {
		$this->assertTrue($this->converter->canConvertFrom('', 'integer'));
	}

	/**
	 * @test
	 */
	public function canConvertFromShouldReturnTrueForANullValue() {
		$this->assertTrue($this->converter->canConvertFrom(NULL, 'integer'));
	}

	/**
	 * @test
	 */
	public function getSourceChildPropertiesToBeConvertedShouldReturnEmptyArray() {
		$this->assertEquals(array(), $this->converter->getSourceChildPropertiesToBeConverted('myString'));
	}
}
?>