<?php
namespace TYPO3\CMS\Beuser\ViewHelpers;

/***************************************************************
 *  Copyright notice
 *
 *  (c) 2012-2013 Felix Kopp <felix-source@phorax.com>
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *  A copy is found in the textfile GPL.txt and important notices to the license
 *  from the author is found in LICENSE.txt distributed with these scripts.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/

/**
 * Displays a section in backend module template, similar to template::section()
 *
 * @author Felix Kopp <felix-source@phorax.com>
 */
class SectionViewHelper extends \TYPO3\CMS\Fluid\Core\ViewHelper\AbstractViewHelper {

	/**
	 * Display section with title and content
	 *
	 * @param string $title
	 * @param boolean $collapsible
	 * @return string
	 * @see template::section()
	 */
	public function render($title, $collapsible = FALSE) {
		if ($collapsible) {
			$uniqueId = 'section_' . md5((microtime() . rand()));
			return '<h3 class="collapsibleSection"><a href="#" onClick="$(\'' . $uniqueId . '\').toggle(); return false;">' . $title . '</a></h3>' . '<div id="' . $uniqueId . '" class="collapsibleSection">' . $this->renderChildren() . '</div>';
		}
		return '<h3>' . $title . '</h3>' . $this->renderChildren();
	}

}

?>